import os
from google.cloud import vision
from openai import OpenAI
import streamlit as st
from PIL import Image
import numpy as np
import io
import tempfile
from roboflow import Roboflow
import supervision as sv
import cv2
import os
from fuzzywuzzy import process
from sendgrid import SendGridAPIClient
from sendgrid.helpers.mail import Mail
SENDGRID_API_KEY=''

def fuzzy_search(file_path, search_term, name_column='Name', email_column='Email', threshold=80):
    # Load the Excel file
    df = pd.read_csv(file_path)

    # Ensure the name and email columns exist
    if name_column not in df.columns:
        raise ValueError(f"Column '{name_column}' not found in the Excel file.")
    if email_column not in df.columns:
        raise ValueError(f"Column '{email_column}' not found in the Excel file.")

    # Perform fuzzy matching
    results = process.extractBests(search_term, df[name_column], score_cutoff=threshold)

    # Fetch corresponding email addresses for the matched names
    matched_emails = [(df[df[name_column] == match[0]][email_column].values[0], match[1]) for match in results]

    # Return the matched names and their email addresses
    return matched_emails

# Example usage
file_path = '/Users/suhaniagarwal/Downloads/calendar/mlpr-project/names_emails.csv'  # Replace with your Excel file path

def send_email(to_email):
    message = Mail(
        from_email='suhaniagarwal221@gmail.com',
        to_emails=to_email,
        subject='Parcel has arrived',
        html_content='Your parcel has been delivered, please collect from gate 1')
    try:
        sg = SendGridAPIClient(SENDGRID_API_KEY)
        response = sg.send(message)
        return f"Email sent! Status code: {response.status_code}"
    except Exception as e:
        return f"An error occurred: {str(e)}"

# Initialize Roboflow
rf = Roboflow(api_key="")
project = rf.workspace().project("mlpr-ld5b3")
model = project.version(7).model
openai_client = OpenAI(api_key='')
os.environ["GOOGLE_APPLICATION_CREDENTIALS"] = "moonlit-text-378911-1755acc2b310.json"
vision_client = vision.ImageAnnotatorClient()

def app():
    st.title("GPT-4 Address Extraction")

    # Option to upload an image
    uploaded_image = st.file_uploader("Upload an image:", type=["jpg", "png", "jpeg"])

    # Option to capture a live picture from the camera
    capture_live_image = st.checkbox("Capture Live Picture")

    if uploaded_image or capture_live_image:
        if capture_live_image:
            # Capture a live picture using the camera
            live_image = st.camera_input("Take a picture")
            if live_image is not None:
                bytes_data = live_image.getvalue()
                image_data = bytes_data
            else:
                st.warning("No live picture captured.")
                return
        else:
            # Use the uploaded image
            image_data = uploaded_image.read()
        with tempfile.NamedTemporaryFile(delete=False, suffix='.jpg') as tmp:
            tmp.write(image_data)
            tmp_path = tmp.name
        st.image(tmp_path, caption='Uploaded Image', use_column_width=True)
        st.write("Processing image with Roboflow...")
        try:
            result = model.predict(tmp_path, confidence=40, overlap=30).json()
            detections = sv.Detections.from_roboflow(result)
            image = cv2.imread(tmp_path)
            label_annotator = sv.LabelAnnotator()
            bounding_box_annotator = sv.BoxAnnotator()
            annotated_image = bounding_box_annotator.annotate(scene=image, detections=detections)
            annotated_image = label_annotator.annotate(scene=annotated_image, detections=detections)
            cropped_image_path = 'annotated_image.jpg'
            cv2.imwrite(cropped_image_path, annotated_image)
            st.image("annotated_image.jpg", caption='Cropped Bounding box', use_column_width=True)
            for det in detections:
                if det[3] == 0:  # det[3] is the class ID
                    bounding_box = det[0]  # det[0] is the bounding box [x_min, y_min, x_max, y_max]
                    break
            x_min, y_min, x_max, y_max = bounding_box
            cropped_image = annotated_image[int(y_min):int(y_max), int(x_min):int(x_max)]
            cropped_image_path = 'cropped_annotated_prediction.jpg'
            cv2.imwrite(cropped_image_path, cropped_image)
            st.image("cropped_annotated_prediction.jpg", caption='Cropped Bounding box', use_column_width=True)
        except Exception as e:
            st.error(f"Error in Roboflow prediction: {e}")
        # Perform text detection when an image is provided
        try:
            with open(cropped_image_path, 'rb') as f:
                image_data = f.read()
            with st.spinner("Detecting text..."):
                image = vision.Image(content=image_data)
                response = vision_client.text_detection(image=image)
                texts = response.text_annotations
                detected_text = [text.description for text in texts]

                # Prepare the OpenAI message
                openai_messages = [
                    {"role": "system", "content": "Extract names and addresses"},
                    {"role": "user", "content": f"Detected Text: {' '.join(detected_text)}"}
                ]

                # Send the user input and context to OpenAI for a response
                response = openai_client.chat.completions.create(model="gpt-3.5-turbo",
                messages=openai_messages)

                # Extract and display the OpenAI response
                ai_response = response.choices[0].message.content
                st.subheader("OpenAI Response:")
                st.write(ai_response)

        except Exception as e:
            st.error(f"Error reading the cropped image file: {e}")

        search_term = ai_response # Replace with your search term
        try:
            matches = fuzzy_search(file_path, search_term)
            for match in matches:
                print("The most similar email found",match[0])
        except Exception as e:
            print(str(e))
        st.write("Please confirm the email id")
        recipient_email = st.text_input("Enter recipient's email", '')

        # Using session state to control the button action
        if 'button_clicked' not in st.session_state:
            st.session_state['button_clicked'] = False

        if st.button('Send Email'):
            if recipient_email and not st.session_state['button_clicked']:
                result = send_email(recipient_email)
                st.session_state['button_clicked'] = True
                st.write(result)
            elif st.session_state['button_clicked']:
                st.write("Email already sent. Refresh the page to send again.")
            else:
                st.write("Please enter a valid email address.")
        
# Run the Streamlit app
if __name__ == '__main__':
    app()
